#!/bin/bash
MODEL_PATH=$1
DATASET="amber"
question_file="<DATA_FOLDER>adam/query_all.jsonl"
pred_file=${MODEL_PATH}/${DATASET}/answers/merge.jsonl
image_folder="<DATA_FOLDER>/amber/image"
# image_folder="/<DATA_FOLDER>/amber/image"
pip install spacy
pip install nltk
python -m spacy download en_core_web_lg


pred_data=$(python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)

if [ -z "${pred_data}" ]; then
    MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
    if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
        echo "qwen-vl in $MODEL_PATH"
        echo "pred file does not exist for ${DATASET}"
        exit 1 
    fi

    python -m llava.eval.model_vqa_loader \
        --model-path ${MODEL_PATH} \
        --question-file ${question_file} \
        --image-folder ${image_folder} \
        --answers-file ${pred_file} \
        --temperature 0 \
        --conv-mode vicuna_v1 

else
    echo "pred file exists for ${DATASET}"
    pred_file=${pred_data}
fi

output_file=${MODEL_PATH}/${DATASET}/answers/results.json
python llava/eval/eval_amber.py \
    --output_file ${output_file} \
    --annotation ${question_file} \
    --inference_data ${pred_file} \
    --annotation_folder <DATA_FOLDER>/amber/annotations --evaluation_type a 
